% Script to compare Tom's PV diagnostic with Curtis's. 
%
% Author Tom, 29/12/95. 

clear
clear global
close all

global x_spacing y_spacing z_spacing NX NY NZ
global u_x_grid v_x_grid w_x_grid p_x_grid PV_x_grid
global u_y_grid v_y_grid w_y_grid p_y_grid PV_y_grid
global u_z_grid v_z_grid w_z_grid p_z_grid PV_z_grid
global x_domain y_domain z_domain
global q slice
global f g c N2 alpha rho_bar flux time this_path Half_flux cooling_width cooling_offset

% Plot cross section of this slice
slice = 100 ;

% Constants. SI units unless explicitly stated otherwise.
Earth_rad  = 6370e3 ;
Radian     = 57.29578 ;
g          = 9.81 ;
c          = 4e3 ;
rho_bar    = 1000 ;
True       = 1 ;
False      = 0 ;
secs_in_a_day = 60*60*24 ;

param_file_name = 'temp' ;
folder = '12960' ;
time    = str2num(folder) * 60 ;

feval(param_file_name) ;
this_path   = [this_path,'/',folder] ;

% Define grids.
setup_grids(x_spacing,y_spacing,z_spacing) ;

% Get surface fluxes.
flux     = Half_flux.*(tanh((2.*(p_y_grid + 125 - cooling_offset))./cooling_width) + 1 ) ;
flux     = [p_y_grid',flux'] ;

% Compare vorticities
fprintf(1,' Getting Toms version of xvort. \n\n') ;
temp = [this_path,'/','xvort.mat'] ;
if( fopen(temp) == -1)
   fprintf(1,' Calculate xvort in matlab using diagnostic.m \n\n\n') ;
   return ;
else
   fprintf(1,' Retrieving xvort from disk ... \n') ;
   fid = fopen(temp,'r') ;
   xvort1 = fread(fid,[NY*NZ,NX],'float32') ;
end

fprintf(1,' Getting Curts version of xvort. \n\n') ;
xvort2 = readmodel('xvort.sun.b',this_path,'float32') ;

xvort1_slice = getyz(xvort1,slice) ;
xvort2_slice = getyz(xvort2,slice) ;

% Compare vorticities
fprintf(1,' Getting Toms version of yvort. \n\n') ;
temp = [this_path,'/','yvort.mat'] ;
if( fopen(temp) == -1)
   fprintf(1,' Calculate yvort in matlab using diagnostic.m \n\n\n') ;
   return ;
else
   fprintf(1,' Retrieving yvort from disk ... \n') ;
   fid = fopen(temp,'r') ;
   yvort1 = fread(fid,[NY*NZ,NX],'float32') ;
end

fprintf(1,' Getting Curts version of yvort. \n\n') ;
yvort2 = readmodel('yvort.sun.b',this_path,'float32') ;

yvort1_slice = getyz(yvort1,slice) ;
yvort2_slice = getyz(yvort2,slice) ;

% Compare vorticities
fprintf(1,' Getting Toms version of zvort. \n\n') ;
temp = [this_path,'/','zvort.mat'] ;
if( fopen(temp) == -1)
   fprintf(1,' Calculate zvort in matlab using diagnostic.m \n\n\n') ;
   return ;
else
   fprintf(1,' Retrieving zvort from disk ... \n') ;
   fid = fopen(temp,'r') ;
   zvort1 = fread(fid,[NY*NZ,NX],'float32') ;
end

fprintf(1,' Getting Curts version of zvort. \n\n') ;
zvort2 = readmodel('zvort.sun.b',this_path,'float32') ;

zvort1_slice = getyz(zvort1,slice) ;
zvort2_slice = getyz(zvort2,slice) ;

figure
title('vorticity components') ;
subplot(3,2,1)
plot(xvort1_slice(18,:),'-') ;
hold on
plot(xvort2_slice(18,:),':') ;
subplot(3,2,2)
plot(xvort1_slice,xvort2_slice,'.') ;
subplot(3,2,3)
plot(yvort1_slice(18,:),'-') ;
hold on
plot(yvort2_slice(18,:),':') ;
subplot(3,2,4)
plot(yvort1_slice,yvort2_slice,'.') ;
subplot(3,2,5)
plot(zvort1_slice(18,:),'-') ;
hold on
plot(zvort2_slice(18,:),':') ;
subplot(3,2,6)
plot(zvort1_slice,zvort2_slice,'.') ;
orient tall

% Compare PVs
fprintf(1,' Getting Toms version of the PV. \n\n') ;
temp = [this_path,'/','q.mat'] ;
if( fopen(temp) == -1)
   fprintf(1,' Calculate the PV in matlab using diagnostic.m \n\n\n') ;
   return ;
else
   fprintf(1,' Retrieving PV from disk ... \n') ;
   fid = fopen(temp,'r') ;
   q1 = fread(fid,[NY*NZ,NX],'float32') ;
end
fclose(fid) ;
q1 = -q1.*g./(f.*N2) ;
q = q1 ;
q1_slice = getyz(q1,slice) ;
clear temp

fprintf(1,' Getting Curts version of the PV. \n\n') ;
q2 = readmodel('q.sun.b',this_path,'float32') ;
q2 = q2.*g./(f.*N2) ;
q = q2 ;
q2_slice = getyz(q2,slice) ;

fprintf(1,' Getting Curts Sverdrupian version of the PV. \n\n') ;
q3 = readmodel('qs.sun.b',this_path,'float32') ;
q3 = -q3.*g./(f.*N2) ;
q = q3 ;
q3_slice = getyz(q3,slice) ;

figure
subplot(3,1,1)
contour(q1_slice)
subplot(3,1,2)
contour(q2_slice)
subplot(3,1,3)
contour(q3_slice)

figure
plot(q1_slice(18,:),'-') ;
hold on
plot(q2_slice(18,:),':') ;
plot(q3_slice(18,:),'-.') ;
axis([0 120 -2 2])  ;

