% Function to differentiate a model variable using centred differences. Very similar 
% to the re-grid function. Set land values to NaN, before calling this function, 
% and these will propagate naturally into the grid.
% Specify the type of grid differentiation (x,y or z) using type.

% Author twnh 3/11/94.

function new_var = d_dn(data,type,grid,domain)

% Assume data is ordered in NY*NZ rows, and NX columns. Y varies most rapidly in the
% row direction. Domain is the total length in the 'type' direction.

global NX NY NZ

% Setup variables.
%NX = 6 ;
%NY = 3 ;
%NZ = 3 ;
%data = [1,2,3,3.5,4.8,NaN;    ...
        %2,4,6,7.6,9,NaN;    ...
        %3,6,9,10,9,NaN] ;
%data = [data;2.*data;3.*data]
%domain = 600 ;
%grid = [1,2.5,3,40,50,600]
%type = 'x' ;
%domain = 3 ;
%grid = [1,2.5,3]
%type = 'y' ;
%domain = 3 ;
%grid   = [1,2.5,3]
%type   = 'z' ;

% Reshape data matrix so that the required direction is the row.
if(type == 'x')
  data = data'   ;
  N    = NX ;
elseif(type == 'y')
  data = reshape(data,NY,NX*NZ)  ;
  N    = NY ;
elseif(type == 'z')
  data = reshape(data',NX*NY,NZ)' ;
  N    = NZ ;
else
  fprintf(1,' ERROR !  Wrong type [%s] in regrid function.\n',type) ;
  return ;
end
%fprintf(1,' done. \n') ;
if(length(grid) ~= N)
  fprintf(1,' ERROR !  Grid definitions inconsistent in regrid function.\n') ;
  length(grid),N
  return ;
end
%fprintf(1,' building temporary matrices ...') ;
new_var  = zeros(N,NY*NZ*NX/N) ;
fac      = zeros(N,NY*NZ*NX/N) ;
factor   = zeros(N+1,NY*NZ*NX/N) ;
data2    = zeros(N+1,NY*NZ*NX/N) ;

%fprintf(1,'   done. \n') ;

% Add in extra row at beginning of matrix to allow for differencing.  
data2 = [data(N,:);data]    ;
clear data

% Build up matrix of spacings to scale the differences by.
fac    = meshgrid(grid,[1:NX*NY*NZ/N])' ;
factor = [ones(1,NX*NY*NZ/N).*(grid(N)-domain);fac]  ;
clear fac

% Do calculation to get new data. Use centred differences.
new_var = data2([1:N],:) - data2([2:N+1],:)   ;
factor  = factor([1:N],:) - factor([2:N+1],:)  ;
new_var = new_var ./ factor ;   

% Reshape final matrix, and return. NB transpose and reshape operators are self inverse.
if(type == 'x')
  new_var = new_var'  ;
elseif(type == 'y')
  new_var = reshape(new_var,NY*NZ,NX) ;
elseif(type == 'z')
  new_var = reshape(new_var',NX,NY*NZ)' ;
end

return
