% Script to extract an xy slice through a data matrix. I.e. looking down from above.
% Matrix returned has columns of x, and rows of y.

function slice = getxy(data,z_index) ;

global NX NY NZ

if(z_index > NZ | z_index < 1 | z_index ~= round(z_index))
  fprintf(1,' ERROR !  Illegal Z index in getxy function. \n') ;
  return ;
end

% Data matrix is set up as NY*NZ rows, and NX columns.

slice = data([((z_index-1)*NY)+1:z_index*NY],:) ;
slice = flipud(slice) ;

return
