% Script to extract an xz slice through a data matrix. I.e. looking north.          
% Matrix returned has columns of x, and rows of z.

function slice = getxz(data,y_index) ;

global NX NY NZ

if(y_index > NY | y_index < 1 | y_index ~= round(y_index))
  fprintf(1,' ERROR !  Illegal Y index in getxz function. \n') ;
  return ;
end

% Data matrix is set up as NY*NZ rows, and NX columns.

rows  = [y_index:NY:NY*NZ] ;
slice = data(rows,:) ;

return
