% Script to extract an yz slice through a data matrix. I.e. looking east.
% Matrix returned has columns of y, and rows of z.

function slice = getyz(data,x_index) ;

global NX NY NZ

if(x_index > NX | x_index < 1 | x_index ~= round(x_index))
  fprintf(1,' ERROR !  Illegal X index in getyz function. \n') ;
  return ;
end

% Data matrix is set up as NY*NZ rows, and NX columns.

slice = data(:,x_index) ;
slice = reshape(slice,NY,NZ)' ;

return
