% Function to calculate the mean of a model field in the y-direction.

% Author Tom, 31/10/94.

function result = meanxz(data,spacing,mask) ;

global NX NY NZ

if(length(spacing) ~= NY)
  fprintf(1,' ERROR !  Wrong spacing vector supplied to meanxz function. \n') ;
  return ;
end

% Mean = integral(data*width) / integral(width)  in direction of integration.
% Need to remove land values from average, use mask variable.

fprintf(1,' Averaging in y-direction ... ') ;
slice = zeros(NZ,NX) ;
dist  = zeros(NZ,NX) ;
for i = 1:NY
  temp  = getxz(data,i)  ;
  temp2 = getxz(mask,i)  ;
  slice = slice + (temp.*temp2.*spacing(i)) ;
  dist  = dist  + (spacing(i).*temp2)  ;
end
fprintf(1,' done. \n') ;

result = slice ./ dist ;


