% Function to calculate the mean of a model field in the x-direction.

% Author Tom, 31/10/94.

function result = meanyz(data,spacing,mask) ;

global NX NY NZ 

if(length(spacing) ~= NX)
  fprintf(1,' ERROR !  Wrong spacing vector supplied to meanyz function. \n') ;
  return ;
end

% Mean = integral(data*width) / integral(width)  in direction of integration.
% Need to remove land values from average, use mask variable.

fprintf(1,' Averaging in x-direction ... ') ;
slice = zeros(NZ,NY) ;
dist  = zeros(NZ,NY) ;
for i = 1:NX
  temp  = getyz(data,i) ;
  temp2 = getyz(mask,i) ;
  slice = slice + (temp.*temp2.*spacing(i)) ;
  dist  = dist  + (spacing(i).*temp2) ;
end
fprintf(1,' done. \n') ;

result = slice ./ dist ;

