% Function to calculate the mixed layer depth based on a simple 1 dimensional law, based on
% an input heat loss vector, a (constant) background stratification, and a time.
% Formula is h = sqrt(2.B.time)/N ;

function depth = mixed_layer(flux,N2,time) ;

global g alpha rho_bar c


% Get B from heat flux.
B = (g*alpha/(rho_bar*c)).*flux ;

% Get vector of mixed layer depths.

depth = -sqrt(2.*B.*time./N2) ;
