% Script to calculate the overturning streamfunction from the model fields.
% Psi is defined to be at a x_vort position (on the cell edge). The streamfunction
% is given in m^3/s. I.e. multiplied by the x_domain size to give the TRANSPORT.
% 
% Author : Tom, Oct '95.

function stream_fn = psi ;

global x_spacing y_spacing z_spacing NX NY NZ
global u_x_grid v_x_grid w_x_grid p_x_grid 
global u_y_grid v_y_grid w_y_grid p_y_grid
global u_z_grid v_z_grid w_z_grid p_z_grid
global x_domain y_domain z_domain
global u v w g rho_bar this_path

stream_fn = zeros(NZ,NY) ;

fprintf(1,' Calculating streamfunction ... \n') ;

% Need to regrid w to a v point and then average over x.
w_mask = (abs(w) > 10*eps) ;
w_mean = meanyz(w,x_spacing,w_mask) ;

% Replace NaN with 0 so cumsum works OK.
temp   = find(isnan(w_mean)) ;
w_mean(temp) = zeros(size(temp)) ;

% Start at (y,z) = (0,0) and loop over z, building up psi.
for k = 1:NZ
   stream_fn(k,:) = cumsum(w_mean(k,:).*y_spacing) ;
end
stream_fn = x_domain.*stream_fn ;

return
