% Script to read in data files from the CM5.
%
% Call read_files(theta,salt,u,v,w,p,this_path)
%
% to read in files theta, salt, u, v, w and p from this_path.
% Author Tom, Sept '95.

function read_files(theta_f, salt_f, u_f, v_f, w_f, p_f, this_path) ;

global theta salt u v w p g rho_bar

% Test to see if each field is required and whether or not it currently exists.

if(theta_f & isempty(theta))
   fprintf(1,' Reading theta ... ') ;
   theta = readmodel('theta.sun.b',this_path,'float32') ;
end

if(salt_f & isempty(salt))
   fprintf(1,' Reading salt ... ') ;
   salt = readmodel('salt.sun.b',this_path,'float32') ;
end

if(u_f & isempty(u))
   fprintf(1,' Reading u ... ') ;
   u = readmodel('u.sun.b',this_path,'float32') ;
end

if(v_f & isempty(v))
   fprintf(1,' Reading v ... ') ;
   v = readmodel('v.sun.b',this_path,'float32') ;
end

if(w_f & isempty(w))
   fprintf(1,' Reading w ... ') ;
   w = readmodel('w.sun.b',this_path,'float32') ;
   w = w./(-g*rho_bar) ;
end

if(p_f & isempty(p))
   fprintf(1,' Reading pressure ... ') ;
   p = readmodel('p.sun.b',this_path,'float32') ;
% may need to scale pressure somehow ?
end

return
