% Function to read in Fortran binary format data from the CM5 non-hydrostatic model.
% Data format is REAL *4 Fortran binary dumps of the arrays.
% Data format is such that the matrix is packed with the row corresponding to
% the y-index, and the column to the x-index. The first NY rows are from the
% top layer of the model, and so on.
%
% array = readmodel(file_name, this_path, format) 

function array = readmodel(file_name, this_path, format)

global NX NY NZ

home_path = pwd ;
cd(this_path) ;

fid = fopen(file_name,'r') ;
if (fid == -1)
  fprintf(1,' ERROR !  Cannot open file [%s]. \n',file_name) ;
  return
end

fprintf(1,' Reading file [%s]  ...', file_name) ;

% Currently data files have 2 extra entries, at the beginning and end, for some
% obscure reason. So Read over the 1st floating point value before reading the
% array.
[dummy,cnt] = fread(fid,1,format) ;
[array,cnt] = fread(fid,[NX, NY*NZ],format) ;
fclose(fid) ;
array = array' ;
fprintf(1,'  OK.\n') ;

cd(home_path) ;

return
