% Function to regrid a variable from 1 grid to another. Only well-behaved grids can
% be handled. Note that the re-gridding is applied periodically, and that no mask is 
% used to determine where the grid point exists or not. Set land values to NaN, before
% calling this function, and these will propagate naturally into the grid.
% Specify the type of grid transformation (x,y or z) using type.

% Author twnh 3/11/94.

function new_var = regrid(data,type,old_grid,new_grid,domain)

% Assume data is ordered in NY*NZ rows, and NX columns. Y varies most rapidly in the
% row direction. Domain is the total length in the 'type' direction.

global NX NY NZ

% Setup variables.
%NX = 4 ;
%NY = 3 ;
%NZ = 3 ;
%data = [1,2,3,NaN;    ...
        %2,4,6,NaN;    ...
        %3,6,9,NaN]  ;
%data = [data ; data.*2 ; data.*3] 
%domain = 4 ;
%old_grid = [1,2,5,7] 
%type = 'x' ;
%domain = 5 ;
%old_grid = [1,2,5] 
%type = 'y' ;
%domain = 5 ;
%old_grid = [1,2,5] 
%type = 'z' ;
%new_grid = old_grid - 0.5

%fprintf(1,' Reshaping data array ... ') ;
% Reshape data matrix so that the required direction is the row.
if(type == 'x')
  data = data'   ;
  N    = NX ;
elseif(type == 'y')
  data = reshape(data,NY,NX*NZ) ;
  N    = NY ;
elseif(type == 'z')
  data = reshape(data',NX*NY,NZ)' ;
  N    = NZ ;
else
  fprintf(1,' ERROR !  Wrong type [%s] in regrid function.\n',type) ;
  return ;
end
%fprintf(1,' done. \n') ;
if(length(new_grid) ~= N | length(old_grid) ~= N)
  fprintf(1,' ERROR !  Grid definitions inconsistent in regrid function.\n') ;
  length(old_grid),length(new_grid) ,N
  return ;
end
factor_1 = zeros(N,NY*NZ*NX/N) ;
factor_2 = zeros(N,NY*NZ*NX/N) ;
new_var  = zeros(N,NY*NZ*NX/N) ;

% Add in extra row at beginning or end of matrix to allow for interpolation, depending 
% on whether the new_grid has smaller or larger values than the old one.

if(min(new_grid) < min(old_grid))
  data = [data(N,:);data] ;
else
  data = [data(1,:);data] ;
end


% Calculate matrices to do interpolation. These have no variation in the column 
% direction. First get vectors.

old   = [old_grid(N) - domain;old_grid(1:N-1)']  ;
new   = [new_grid']  ;
vec_a = new - old    ;
vec_b = old_grid'-new_grid' ;
vec_ab= vec_a + vec_b  ;
temp1 = vec_a ./ vec_ab ;
temp2 = vec_b ./ vec_ab ;
temp3 = NY*NZ*NX / N  ;
factor_1 = meshgrid(temp1,[1:temp3])' ;
factor_2 = meshgrid(temp2,[1:temp3])' ;
%fprintf(1,' Starting calculation. ') ;

% Do calculation to get new data.
new_var = factor_2.*data([1:N],:) + factor_1.*data([2:N+1],:) ;
%fprintf(1,' Finished calculation.\n ') ;

% Reshape final matrix, and return. NB transpose and reshape operators are self inverse.
if(type == 'x')
  new_var = new_var'  ;
elseif(type == 'y')
  new_var = reshape(new_var,NY*NZ,NX) ;
elseif(type == 'z')
  new_var = reshape(new_var',NX,NY*NZ)' ;
end

return


