% Function to calculate the volume integral of a scalar property in the model grid.
% The scalar must be defined at the centres of grid cells; i.e p,T,S points, so that the
% spacing arrays correctly refer to the dimensions of each cell.
% Those cells for which the value of the mask is = 0 are removed from the integral.
% This function expects the scalar and mask variable to be in an array packed as per
% the standard arrays. I.e. NZ slices of NY*NX sections.

function integ = volume_integ(scalar,x_space,y_space,z_space,mask)

global NX NY NZ

temp   = find(mask == 0) ;
scalar(temp) = zeros(size(temp)) ;

scalar = reshape(scalar,1,(NX*NY*NZ))  ;
temp   = y_space'*x_space  ;
volume = zeros(NY*NZ,NX) ;

for i =1:NZ
  volume([((i-1)*NY)+1:i*NY],:) = temp .* z_space(i) ;
end
volume = reshape(volume,1,(NX*NY*NZ)) ;
mask   = reshape(mask,1,(NX*NY*NZ)) ;

integ = sum(scalar .* volume .* mask)  ;



