% Function to calculate the volume mean of a scalar property in the model grid.
% The scalar must be defined at the centres of grid cells; i.e p,T,S points, so that the
% spacing arrays correctly refer to the dimensions of each cell.

function integ = volume_mean(scalar,x_space,y_space,z_space,mask)

global NX NY NZ

scalar = reshape(scalar,1,(NX*NY*NZ)) ;
temp   = y_space'*x_space ;
volume = zeros(NY*NZ,NX) ;

for i =1:NZ
  volume([((i-1)*NY)+1:i*NY],:) = temp .* z_space(i) ;
end
volume = reshape(volume,1,(NX*NY*NZ)) ;
mask   = reshape(mask,1,(NX*NY*NZ)) ;

integ = sum(scalar .* volume .* mask)/sum(mask.*volume) ;
